<%@ Page Language="VB" AutoEventWireup="false" CodeFile="Try-catch-finally.aspx.vb" Inherits="Select_MySQL" %>
<%@ Import Namespace="System.Data" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>My account</title>
</head>
<body>
<form id="form1" runat="server">
<h1>Structured error handling with Try / Catch / Finally</h1>
    In this example we are going to use structured error handling in the code to control
    and handle exceptions. If you expect that exceptions might occur in some part of
    your code then you should make sure to handle these exceptions in the code because
    unhandled exceptions will lead to a crash in your application and that will not
    be popular at your web hosting company and not very popular among your website users.<br />
    <br />
    You can handle and control exceptions in your code by putting your code inside a
    "Try" block and use one or more "Catch" blocks to handle exceptions. A try block
    without a "Catch" block will not be able to handle exceptions and a "Try" block
    without a "Catch" block will therefore be useless. You can include many "Catch"
    blocks inside a "Try" block to handle certain types of exceptions, every "Catch"
    block is evaluated from top to bottom and you should therefore include specific
    exceptions first and general exceptions last. There is one general exception argument
    that will catch any kind of system or application exception and that exception argument
    is "Exception" (Catch exMessage As Exception), you can also create a "Catch" statement
    without an exception argument (Catch) to catch any kind of system or application
    exception. If you declare variables inside a "Try" structure then you can not use
    these variables outside the "Try" structure and you therefore have to make sure
    that you declare variables outside a "Try" structure if you want to use them outside
    and inside of the "Try" structure.<br />
    <br />
    You can write code in a "Catch" block to provide information about a exception to
    your users or to your self but you dont need to write any code in the "Catch" block
    if you dont want to give any information about the exception. When you have written
    a "Try" structure in the code to a "Web form" you can give information about the
    exception with the "Response.Write" method (Response.Write(exMessage.Message)) but
    if you include a "Try" structure in a "Class" file then you need to throw the exception
    message (Throw New Exception("MyExceptionCategory", ex)) up in the hierarchy.<br />
    <br />
    When there is an exception caused by code that are inside a "Try" block there will
    be an immediate jump in the process to the "Catch" statements. If the code inside
    the "Try" block uses objects that have a dispose (or close or close and dispose)
    method there is a high risk that some or all of these objects not have been disposed
    of (closed) when there is an exception and this leads to memory leakage if you not
    handle this in one of two ways. You can include a "Finally" block inside a "Try"
    structure where you can call dispose (or close) on objects with a dispose method
    or you can use the the "Using" block when you create new instances of classes that
    have a dispose (or close) method. Code written inside the "Finally" block will always
    run before the process exits from a "Try" structure and you can therefore write
    code in a "Finally" block to make sure that some operations are excecuted even if
    there is an exception.<br />
    <br />
    You should not write all of your code inside "Try" blocks because it will give you
    some loss in performance, you should use "Try" blocks when you anticipate that there
    can be exceptions in the code that not are handled with some other method like "IF"
    statements. When you are working with databases (select, insert, update and delete)
    you can expect exceptions and should therefore put your database code inside a "Try"
    block like we have done in this example. A possible exception when you are working
    with data in databases is that your code cant establish a connection to the database,
    it can happen if the database server is down.<br />
    <br />
    <asp:Button ID="btnGetData" runat="server" Text="Get data" /><br />
    <br />
    <asp:Repeater ID="SelectToRepeaterDataReader" runat="server">
        <HeaderTemplate>
            <table border="0" width="1024px" cellpadding="2" cellspacing="0" style="border: solid 1px silver">
                <tr class="menu" style="height:20px">
                    <th>Place</th>
                    <th>AssetID</th>
                    <th>Name</th>
                    <th>Ver. #</th>
                    <th>Supplier</th>
                    <th style="text-align:center">Counted</th>
                    <th>Sign.</th>
                    <th>Comment</th>
                </tr>
        </HeaderTemplate>
        <ItemTemplate>
                <tr>
                    <td><asp:Literal ID="PlaceLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "Place")%>'></asp:Literal></td>
                    <td><asp:Literal ID="AssetOwnIDLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetOwnID")%>'></asp:Literal></td>
                    <td><asp:Literal ID="AssetNameLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetName")%>'></asp:Literal></td>
                    <td><asp:Literal ID="VerNumberLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "VerNumber")%>'></asp:Literal></td>
                    <td><asp:Literal ID="SupplierLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "Supplier")%>'></asp:Literal></td>
                    <td style="text-align:center"><asp:Literal ID="InventCheckBox" runat="server" Text="[  ]"></asp:Literal></td>
                    <td><asp:Literal ID="SignLiteral" runat="server" Text="..............."></asp:Literal></td>
                    <td><asp:Literal ID="CommentLiteral" runat="server" Text="......................."></asp:Literal></td>
                </tr>
        </ItemTemplate>
        <FooterTemplate>
        </table>
        </FooterTemplate>
    </asp:Repeater>
    <asp:HiddenField ID="HiddenCompanyID" runat="server" />
</form>
</body>
</html>

